-- Minetest 0.4 mod: default
-- See README.txt for licensing and other information.

-- The API documentation in here was moved into game_api.txt

-- Load support for MT game translation.
local S = minetest.get_translator("default")

-- Definitions made by this mod that other mods can use too
default = {}

default.LIGHT_MAX = 14
default.get_translator = S

-- GUI related stuff
minetest.register_on_joinplayer(function(player)
	player:set_formspec_prepend([[
			bgcolor[#080808BB;true]
			background[5,5;1,1;gui_formbg.png;true]
			background9[5,5;1,1;gui_formbg.png;true;10]
			listcolors[#00000069;#5A5A5A;#141318;#30434C;#FFF] ]])
end)

function default.get_hotbar_bg(x,y)
	local out = ""
	for i=0,3,1 do
		out = out .."image["..x+i..","..y..";0,1;gui_hb_bg.png]"
	end
	return out
end

default.gui_survival_form = "size[8,8.5]"..
			"list[current_player;main;0,4.25;8,1;]"..
			"list[current_player;main;0,5.5;8,3;8]"..
			--"list[current_player;craft;1.75,0.5;3,3;]"..
			--"list[current_player;craftpreview;5.75,1.5;1,1;]"..
			--"image[4.75,1.5;1,1;gui_furnace_arrow_bg.png^[transformR270]"..
			"listring[current_player;main]"..
			--"listring[current_player;craft]"..
			default.get_hotbar_bg(0,4.25)

minetest.register_on_newplayer(function(player)
    local name = player:get_player_name()
    local meta = player:get_meta()
    meta:set_int("difficulty", 1)
    meta:set_int("days", 25)
    meta:set_int("dayspass", 0)
end)


-- Load files
local default_path = minetest.get_modpath("default")

dofile(default_path.."/functions.lua")
dofile(default_path.."/nodes.lua")
dofile(default_path.."/torch.lua")
dofile(default_path.."/tools.lua")
dofile(default_path.."/mapgen.lua")
dofile(default_path.."/jungle.lua")
dofile(default_path.."/hud.lua")
dofile(default_path.."/Inicialmessage.lua")


survival={}
local default_path = minetest.get_modpath("survival")
local q = minetest.settings:get("texturequality") or 1

minetest.register_node('default:dirtwithgrass1', {
	tiles ={'dirtQ'..q..'.png^grassQ'..q..'.png', 'dirtQ'..q..'.png'}, 
	description= 'dirt',
	drawtype= 'normal',
	is_ground_content=true,
	climbable=false,
	buildable_to=false,
	damage_per_second=10,
	diggable=true,
	drop= '',
	drowning=1,
	floodable=false,
	range=1.0,
	sunlight_propagates=false,
	use_texture_alpha=false,
	walkable=true,
	pointable=true,
})
minetest.register_node('default:dirt', {
	tiles ={'dirtQ'..q..'.png'}, 
	description= 'dirt',
	drawtype= 'allfaces_optional',
	is_ground_content=true,
	climbable=false,
	buildable_to=false,
	damage_per_second=10,
	diggable=true,
	drop= '',
	drowning=1,
	floodable=false,
	range=10.0,
	sunlight_propagates=false,
	use_texture_alpha=false,
	walkable=true,
	pointable=true,
	waving=0,
})
minetest.register_node('default:tree', {
	tiles ={'woodQ'..q..'.png'}, 
	description= 'tree',
	drawtype= 'mesh',
	mesh= 'tree.obj',
	is_ground_content=true,
	climbable=false,
	buildable_to=false,
	damage_per_second=10,
	diggable=true,
	drop= '',
	drowning=1,
	floodable=false,
	range=1.0,
	sunlight_propagates=false,
	use_texture_alpha=false,
	walkable=false,
	pointable=true,
	waving=0,
	collisionbox = {-0.5, 0.0, -0.5, 0.5, 10.0, 0.5},
})
minetest.register_node('default:treebase', {
	tiles ={'woodQ'..q..'.png'}, 
	description= 'treebase',
	drawtype= 'mesh',
	mesh= 'treebase.obj',
	is_ground_content=true,
	climbable=false,
	buildable_to=false,
	damage_per_second=10,
	diggable=true,
	drop= '',
	drowning=1,
	floodable=false,
	range=1.0,
	sunlight_propagates=false,
	use_texture_alpha=false,
	walkable=true,
	pointable=true,
	waving=0,
})
minetest.register_node('default:tree_leaves', {
	tiles ={'leavesfullQ'..q..'.png'}, 
	description= 'tree',
	drawtype= 'mesh',
	mesh= 'leaves.obj',
	is_ground_content=true,
	climbable=false,
	buildable_to=false,
	damage_per_second=10,
	diggable=true,
	drop= '',
	drowning=1,
	floodable=false,
	range=1.0,
	sunlight_propagates=false,
	use_texture_alpha=false,
	walkable=true,
	pointable=true,
	waving=0,
})

minetest.register_node('default:deco1', {
	tiles ={'leave1Q'..q..'.png'}, 
	description= 'tree',
	drawtype= 'mesh',
	mesh= 'deco1.obj',
	is_ground_content=true,
	climbable=false,
	buildable_to=false,
	diggable=true,
	drop= '',
	drowning=1,
	floodable=false,
	range=1.0,
	sunlight_propagates=false,
	use_texture_alpha=false,
	walkable=false,
	pointable=false,
	waving=0,
})
minetest.register_node('default:deco2', {
	tiles ={'leave2Q'..q..'.png'}, 
	description= 'tree',
	drawtype= 'mesh',
	mesh= 'deco2.obj',
	is_ground_content=true,
	climbable=false,
	buildable_to=false,
	diggable=true,
	drop= '',
	drowning=1,
	floodable=false,
	range=1.0,
	sunlight_propagates=false,
	use_texture_alpha=false,
	walkable=false,
	pointable=false,
	waving=0,
})
minetest.register_node('default:deco3', {
	tiles ={'leave3Q'..q..'.png'}, 
	description= 'tree',
	drawtype= 'mesh',
	mesh= 'deco3.obj',
	is_ground_content=true,
	climbable=false,
	buildable_to=false,
	diggable=true,
	drop= '',
	drowning=1,
	floodable=false,
	range=1.0,
	sunlight_propagates=false,
	use_texture_alpha=false,
	walkable=false,
	pointable=false,
	waving=0,
})
minetest.register_node('default:deco4', {
	tiles ={'leave4Q'..q..'.png'}, 
	description= 'tree',
	drawtype= 'mesh',
	mesh= 'deco4.obj',
	is_ground_content=true,
	climbable=false,
	buildable_to=false,
	diggable=true,
	drop= '',
	drowning=1,
	floodable=false,
	range=1.0,
	sunlight_propagates=false,
	use_texture_alpha=false,
	walkable=false,
	pointable=false,
	waving=0,
})
--
-- Nodes overrider
